'--------------------------------H-Comp---------------------------------
'Written by Michael E. Nielsen, Ph.D.
'This program allows you to enter binary (1,0) data used in calculating
'Scott's H, a measure of information complexity.  First, you input the
'subject identification and the number of sorts.  Next, input either
'either a 1 or a 0 to indicate which adjectives were used in describing
'that sort.  The program calculates the complexity (or redundancy)
'of the information, and writes output to two files.  The file  H.DAT
'stores the subject identifier, complexity score, and number of aspects
'used.  The file RAW.OUT stores the subject identifier and the raw data
'entered for calculating scores, which can be used to verify data entry.

COLOR 15,1                       'set blue background and white letters
OPEN "h.dat" FOR APPEND AS #1
OPEN "raw.out" FOR APPEND AS #2
DIM Aspect$ (60), DscrptnAttrbt (60)            'set the maximum number of sorts at 60
DIM H$ (60), SKIP$ (60),  VALUSUM (60),  LOGVAL# (60), I (60)
COUNTER=1
CLS

'---------------------Get Data or Input Data------------------------
DataIn:
PRINT : PRINT
PRINT "                                 H-Comp"  : PRINT
PRINT "                         by Michael E. Nielsen"   : PRINT
PRINT "          Data can be entered directly from the keyboard, or from"
PRINT "          a plain-text (ascii) file.  It is essential that data are"
PRINT "          structured so that H-COMP can find the information."
PRINT "          Consult with the Behavior Research Methods, Instruments,"
PRINT "          & Computers article (1996, vol. 28, no. 3, pp. 483-485)"
PRINT "          if you have any questions about how to structure"
PRINT "          your ascii file, or concerning the way that data must"
PRINT "          be organized prior to using this program." : PRINT

PRINT : PRINT : PRINT

ContinueQuestion:
INPUT "Do you wish to continue?  (Y/N)"; GO$
	SELECT CASE GO$
		CASE = "Y" , "y"
                	GOTO ContinueYes
		CASE = "N" , "n"
			END
		CASE ELSE
                	PRINT :	PRINT "Please answer Y or N"
                        GOTO ContinueQuestion
	END SELECT

ContinueYes:
cls : PRINT : PRINT
PRINT " Standard Disclaimer:  H-Comp is provided `as is' without warranty of "
PRINT "          any kind.  Michael E. Nielsen and Georgia Southern University"
PRINT "          make no claim concerning the accuracy or correctness contained"
PRINT "          in, or the results of the use of H-Comp.  You are urged to "
PRINT "          verify the accuracy of H-Comp analyses.  The entire risk as "
PRINT "          to the results and performance of H-Comp is assumed by you."
PRINT "          If H-Comp is defective, you, and not Michael E. Nielsen or"
PRINT "          Georgia Southern University assume the entire cost of all"
PRINT "          necessary servicing, repair or correction."
PRINT: PRINT : PRINT "Enter  K  for keyboard data entry, or ";
INPUT " F  to use an ascii file  (K/F)  ", DATATYPE$
SELECT CASE Datatype$
        CASE  = "F", "f"
	       	GOTO FileInput
        CASE  = "K", "k"
          	GOTO KeyInput
        CASE ELSE
           	PRINT
                PRINT "Please answer K or F "
                GOTO ContinueYes
END SELECT



'-------------------Input Data from File R.DAT------------------------
FileInput:
PRINT: PRINT "Enter the name of the ASCII file"
INPUT "containing the data to be analyzed  ", Rawin$
OPEN Rawin$ FOR INPUT AS #3
PRINT "JUST ABOUT TO ENTER FILE-INPUT LOOP"
WHILE NOT EOF (3)
   FOR P=1 TO 60 : Aspect$(P) = "" : NEXT P
   LINE INPUT #3, SUBJ$                'get subject ID & count r.dat line
   PRINT "Reading data for subject " SUBJ$
   LINE INPUT #3, E$
   E = VAL(E$)
   PRINT "Number of adjectives used in description was " E
   LINE INPUT #3, NUMSORTS$            'get # of sorts
   print "variable NUMSORTS$ = " numsorts$
   SA% = VAL(NUMSORTS$)
   FOR READSORT = 1 TO SA%         'loop to read sorts from file
       PRINT "READING aspect " readsort
       LINE INPUT #3, Aspect$(readsort)
       print "aspect " readsort ": " Aspect$(readsort)
   NEXT READSORT
   GOSUB Main
WEND
PRINT
IF EOF (3) THEN PRINT "Calculations are completed"
CLOSE #1 : CLOSE #2
END


'---------------------Keyboard Data Entry Routine--------------------
KeyInput:
INPUT "Who is your subject"; SUBJ$
INPUT "How many adjectives were available for sorting"; E : PRINT
IF E > 60  THEN
	COLOR 14,1 : BEEP
	PRINT "There are too many adjectives for the defaults
        PRINT "of this program.  You may wish to modify the "
        PRINT "source code so that it will meet your needs."
        PRINT "Contact the author if you need help doing this."
        END
ELSEIF E < 1 THEN
	COLOR 14,1 : BEEP
	PRINT "There must be at least some adjectives."
        PRINT "Please double-check your data, and restart"
        PRINT "the program if you entered an incorrect digit."
        END
END IF
PRINT : INPUT; "How many sorts does this subject have"; SA% : PRINT
PRINT : PRINT "For each sort, use a 1 to show that the adjective"
PRINT "was used, or a 0 to show that the adjective was not used."
PRINT "It is essential that adjective numbers be held constant"
PRINT "throughout the sorts.  That is, Adjective 1 must be the "
PRINT "same adjective in Sort 1 as in Sort 2, etc.  Use the"
PRINT "numbered guide to keep track of the adjective being entered."
PRINT "After describing each sort, press <ENTER>."
FOR P=1 TO SA%
    PRINT
    PRINT "                ADJECTIVE NUMBER:"  : PRINT
    ADJLIST1$ = "         1         2         3         4         5         6"
    ADJLIST2$ = "123456789012345678901234567890123456789012345678901234567890"
EntryGuide:
    IF P<10 THEN PRINT "                " MID$ (ADJLIST1$, 1, E)
    IF P>9 THEN PRINT "                 " MID$ (ADJLIST1$, 1, E)
    IF P<10 THEN PRINT "                " MID$ (ADJLIST2$, 1, E)
    IF P>9 THEN PRINT "                 " MID$ (ADJLIST2$, 1, E)
    PRINT "SORT NUMBER " P; : INPUT ":", Aspect$(P)
    IF LEN(Aspect$(P)) <> E THEN BEEP             'screen for too many values
    IF LEN(Aspect$(P)) <> E THEN COLOR 14,1
    IF LEN(Aspect$(P)) <> E THEN PRINT "Incorrect number of adjectives. Please enter these data again."
    COLOR 15,1
    IF LEN(Aspect$(P)) <> E THEN GOTO EntryGuide
    FOR DIGITS = 1 TO E            'screen each digit for incorrect values
        IF MID$ (Aspect$(P), DIGITS,1) = "0" THEN GOTO OKDigit
        IF MID$ (ASPECT$(P), DIGITS,1) = "1" THEN GOTO OKDigit
        color 14,1 : PRINT
	PRINT "    Incorrect data entry."
	PRINT "    Acceptable values are 1 and 0 only."
	PRINT "    Please enter these data again." : color 15,1 : PRINT
	BEEP
	GOTO EntryGuide
OKDigit:
    NEXT DIGITS
NEXT P



'---------------------------Main Program---------------------------
Main:

CLS : LOCATE 6,6 : PRINT "...computing complexity score..."


GOSUB AdjUseRoutine                                       'calculate complexity score

PRINT : PRINT "Subject identified as " subj$
PRINT#1, SUBJ$, SC!, SA%    'print subject ID, score, self-aspects to file1
PRINT#2, SUBJ$
FOR P=1 TO SA%                                     'print raw data to file2
    PRINT#2, "     "Aspect$(P)
NEXT P
PRINT "had a complexity score of "   USING "#.#####" ; SC!
PRINT "using" SA% "aspects."

LOGVALSUM# = 0.0			'clear sc for next computation
FOR clean = 1 to 60			'clear values for next computation
        Aspect$(clean) = ""
        DscrptnAttrbt(clean) = 0
        H$(clean) = ""
        SKIP$(clean) = ""
        VALUSUM(clean) = 0
        LOGval#(clean) = 0
        I(clean) = 0
NEXT


IF DATATYPE$ = "F" THEN RETURN
IF DATATYPE$ = "f" THEN RETURN
PRINT : PRINT
IF DATATYPE$ = "k" THEN
        PRINT  "Ready to enter data for the next subject"
        PRINT  "Or, simultaneously press   <Ctrl>  and  <Break>  to end data entry"
	GOTO KeyInput
END IF
IF DATATYPE$ = "K" THEN
        PRINT  "Ready to enter data for the next subject"
        PRINT  "Or, simultaneously press  <Ctrl>  and  <Break>  to end data entry
        GOTO KeyInput
END IF





close #1 : close #2
END



'----------------------------------------------------------------------
'-------------------------adjective-use loop---------------------------
'Transforms the self-descriptions into variables indicating whether or not
'the attribute was used for each role.
AdjUseRoutine:
K$=""
FOR B=1 TO E                             'set number of adjectives (E)
    FOR A=1 TO SA%                       'create H$ for each adjective
        K$ = MID$ (Aspect$(A), B, 1)
        M = ASC(K$)
        H$(B) = H$(B) + CHR$(M)
    NEXT A
    FOR F=1 TO E                 'count the times that adjectives are used
        DscrptnAttrbt(B)= DscrptnAttrbt(B) + VAL(MID$(H$(B), F, 1))
    NEXT F
    COUNTER = COUNTER+1
NEXT B

'------------screen for previously-counted adjectives-----------------

FOR X = 1 TO E		       'set SKIP to  No
    SKIP$(X) = "N"
NEXT X

FOR X=1 TO E                   'compare adjectives that haven't been compared
     IF SKIP$(X) = "N" THEN GOSUB CompareAdj
NEXT X
GOSUB AssgnLog2vals                          'go assign log2 values
RETURN


'---------------adjective comparison loop-------------------------

CompareAdj:
COMPARE=X
G=0
FOR C=COMPARE + 1 TO E
    IF H$(COMPARE) = H$(C)  THEN I(COMPARE) = G + 1
    IF H$(COMPARE) = H$(C)  THEN G = I(COMPARE)
    IF H$(COMPARE) = H$(C)  THEN SKIP$(C) = "Y"
NEXT C
VALUSUM(COMPARE) = G+1
RETURN


'-------------assigning log2 values loop--------------------------
AssgnLog2Vals:
FOR LG = 1 TO E
         IF VALUSUM(LG) < 2  THEN LOGVAL#(LG) = 0
         IF VALUSUM(LG) > 1 THEN LOGVAL#(LG) = (VALUSUM(LG))*(LOG(VALUSUM(LG)) / LOG(2))
NEXT LG
LG = 1
FOR LG = 1 TO E
    LOGVALSUM#=LOGVALSUM#+LOGVAL#(LG)
NEXT LG
SC# = (LOG (E) / LOG (2)) - (LOGVALSUM# / E)    'H formula (Scott, 1969)
SC!=SC#
RETURN




